﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.Generic
{
    /// <summary>
    /// Represents an object that stores compliance modeling data based on a combination of vehicle's class and style. This object
    /// supports deep member cloning by requiring that each variable of this generic class implement the <see cref="ICloneable"/>
    /// interface.
    /// </summary>
    [Serializable]
    public class VCXObject<T> : VCXValue<T>, ICloneable where T : ICloneable
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="VCXObject{T}"/> class.
        /// </summary>
        public VCXObject() : base() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="VCObject{T}"/> class using the specified values.
        /// </summary>
        public VCXObject(T cars, T vans, T suvs, T pickups, T class12a, T zevs, T class2b3)
            : base(cars, vans, suvs, pickups, class12a, zevs, class2b3) { }

        #endregion

        #region /*** Methods ***/

        #region /* ICloneable Members */

        /// <summary>
        /// Creates a copy of the current <see cref="VCXObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="VCXObject{T}"/>.</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        /// <summary>
        /// Creates a copy of the current <see cref="VCXObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="VCXObject{T}"/>.</returns>
        public new VCXObject<T> Clone()
        {
            VCXObject<T> value = new VCXObject<T>();
            this.CopyTo(value);
            return value;
        }
        /// <summary>
        /// Copies the members of the current <see cref="VCXObject{T}"/> instance into the specified value.
        /// </summary>
        /// <param name="value">The value where to copy the members of the current instance.</param>
        protected void CopyTo(VCXObject<T> value)
        {
            for (int i = 0; i < this.Items.Length; i++)
            {
                value.Items[i] = (T)this.Items[i].Clone();
            }
        }

        #endregion

        #endregion

    }
}
